﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wykorzystanie urlopów na żądanie</title>
		<script runat="server">

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			UstawRok();
		}
		
		FromTo okres;
		[Caption("Urlopy za okres")]
		public FromTo Okres {
			get { return okres; }
			set { 
				if (value == FromTo.Empty || value == FromTo.All)
					UstawRok();
				else
					okres = value; 
			}
		}	
		
		void UstawRok() {
			Date data;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
			okres = FromTo.Year(data.Year);
		}		
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

    int limit;
	KalendModule kalend;
	DefinicjaLimitu definicja;
	
	void OnContextLoad(Object sender, EventArgs args) {
		if (pars.Okres == FromTo.Year(pars.Okres.To.Year))
			ReportHeader1["OKRES"] = "na " + pars.Okres.To.Year + " rok";
		else
			ReportHeader1["OKRES"] = "za okres " + pars.Okres.ToString();
	
		kalend = KalendModule.GetInstance(dc);
		definicja = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
        limit = kalend.Config.Nieobecności.UrlopWypoczynkowy.LimitUrlopuNaŻądanie;
	}
	
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		PracHistoria ph = (PracHistoria)args.Row;
        FromTo okres = pars.Okres;

        int dni = 0;
        if (okres.Contains(ph.WypoczynkowyBO.Data)) {
            dni = ph.WypoczynkowyBO.NaZadanie;
            okres = new FromTo(ph.WypoczynkowyBO.Data, okres.To);
        }
        KalkulatorPracownika kalk = new KalkulatorPracownika(ph.Pracownik);
        foreach (OkresNieobecności on in kalk.Nieobecnosci(okres, true))
            if (on.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopWypoczynkowy &&
                on.Urlop.Przyczyna == PrzyczynaUrlopu.NaŻądanie)
                dni += kalk.Norma(on.Okres).Dni;

        colWymiar.EditValue = limit;
        colWykorzystano.EditValue = dni;
        colPozostalo.EditValue = limit > dni ? limit - dni : 0;
    }
    
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UrlopyNaZadanie" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Wykorzystanie urlopów na żądanie<br/>%OKRES%" runat="server"></cc1:reportheader>
            <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Pracownik.Kod" Caption="Kod" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Caption="Wymiar urlopu na żądanie" HideZero="True" ID="colWymiar"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Caption="Wykorzystano urlopu na żądanie" HideZero="True" ID="colWykorzystano"
						VAlign="Top" runat="server"></ea:GridColumn>
                    <ea:GridColumn Width="12" Caption="Pozostało urlopu na żądanie" HideZero="True" ID="colPozostalo"
						VAlign="Top" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
